(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    109543,       3227]
NotebookOptionsPosition[    102953,       3050]
NotebookOutlinePosition[    103304,       3065]
CellTagsIndexPosition[    103261,       3062]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Houghton Camera", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["HoughtonCamera",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["spes",
           FontWeight->Bold], Cell["list of thickness of the doublet"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[CapitalDelta]",
           FontWeight->Bold], Cell[
          "distance between the corrector and the mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["CameraType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["\"SD\""], Cell["\<\
Houghton's Camera with symmetrix doublet - no control of astigmatism\
\>"]},
         {"\[SpanFromAbove]", Cell["\"DDR\""], Cell["\<\
Houghton's Camera with doublet with different radii - no control of \
astigmatism\
\>"]},
         {"\[SpanFromAbove]", Cell["\"SDCM\""], Cell[
          "Houghton's Camera with symmetrix doublet and conic mirror"]},
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["\"Report\""], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Print\""], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Basic\""], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["\"Values\""], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["\"Full\""], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["\"Minimal\""], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["HoughtonCameraInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of Houghton Camera", "Title"],

Cell[TextData[{
 "Houghton's Camera is formed by an afocal doublet ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " of two thin lenses of the same glass, which have the task to eliminate the \
spherical aberration and coma of the primary mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ". Since ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " does not introduce astigmatism, there is no possibility to control the \
astigmatism of the primary mirror, which depends on the distance \[Delta]",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " between ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " (see Figure)."
}], "Text",
 CellChangeTimes->{{3.394606562453125*^9, 3.3946066120625*^9}, 
   3.41423984434375*^9, 3.4148972829375*^9, 3.41489737771875*^9, {
   3.414897457453125*^9, 3.41489746659375*^9}, {3.437541467703125*^9, 
   3.437541468265625*^9}, {3.43754552821875*^9, 3.437545546375*^9}, {
   3.43891597834375*^9, 3.43891603490625*^9}, 3.6773356986525226`*^9, 
   3.6773373694121013`*^9}],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0001PP0@000800000100000@000041001d0000
00000000002I7`00I@h00215CDH0004081P004d1000200002P0006`00000000000@0000300100@00
l0000000000000000000003R1020Z@<0@`1_0780I@1/04D0C@160000000A0000300000P0000:0000
40000000000000002@000100000100000@0000X0000@000000000000000900004000004000010000
3000010000000000000000/0000@00000@000040000C000030000040000V00007000004000000000
00000000000U8Qh09@0000`000010000>`0000P0000K000040000040000i0000=P00010000010@00
>@0003`000080000@00001P000010000>@000041000i00009@0000`000070020:00000`000010000
8@0000P0000k0000200001/0000@0000lP000040000f000040000?T000010000=P000100003i0000
LP0003H0000@0000lP000780001H0000:000000000000000ooooooooool30000mP140?H0;`3b0040
?00000P000130000300000D0000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<0000?8000010000l`00074000050000lP1b0?800@3c0040l`1b0?80LP0U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<0000?8000010000m000074000050000lP1b0?800@3d0040
m01b0?80LP0U000030000000080U0000300000L0080X000030000040000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<0000?<000010000m@00074000050000
l`1b0?<00@3e0040m@1b0?<0LP0U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<0000?@000010000
mP00074000050000m01b0?@00@3f0040mP1b0?@0LP0U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<0000?D000010000m`00074000050000m@1b0?D00@3g0040m`1b0?D0LP0U000030000000080U0000
300000L0080X000030000040000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<0000?H000010000n000074000050000mP1b0?H00@3h0040n01b0?H0LP0U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<0000?L000010000n000074000050000m`1b0?L00@3i0040
n@1b0?L0LP0U000030000000080U0000300000L0080X000030000040000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<0000?P000010000n000074000050000
n01b0?P00@3i0040n@1b0?P0LP0U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<000000000000000
ooooooooool50000n@1b0?T00@3j0040nP1b0?T0LP0U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<000000000000000ooooooooool50000n@1b0?T00@3i0040n@1b0?T0LP0U000030000000080U0000
300000L0080X000030000040000R000030000?oooolV0000700000400000000000000000000U8Qh0
9@0000`000010000>`0000P0000K000040000?8000010000=P000100003i00000@0003H0000@0000
n@000780000f000040000?80001b0000F00002P00000000000000?oooooooooo0`000?H0A03f02l0
lP0103`000080000@00001P0003b00000@000?T0001b00009@0000`000070020:00000`000010000
8@0000P0000k0000200001/0000@00006P0000P0000f00004000024000080000F00002P000000000
00000?oooooooooo0`0002<0;`0S04808@1/03H0000@00006P0006`0001H0000:000000000000000
ooooooooool30000601601P0;00J00P0?00000P000130000300000D0000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<00001T0000800006P0006/000050000
6@1/01T0200J00P06P1/01T0K00U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<00001T000080000
6`0006/0000500006@1/01T0200K00P06`1/01T0K00U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<00001X000080000700006/0000500006P1/01X0200L00P0701/01X0K00U000030000000080U0000
300000L0080X000030000040000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<00001/0000800007@0006/0000500006`1/01/0200M00P07@1/01/0K00U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<00001`0000800007P0006/000050000701/01`0200N00P0
7P1/01`0K00U000030000000080U0000300000L0080X000030000040000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<00001d0000800007`0006/000050000
7@1/01d0200O00P07`1/01d0K00U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<00001h000080000
800006/0000500007P1/01h0200P00P0801/01h0K00U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<00001l0000800008@0006/0000500007`1/01l0200Q00P08@1/01l0K00U000030000000080U0000
300000L0080X000030000040000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<0000200000800008P0006/000050000801/0200200R00P08P1/0200K00U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<0000240000800008P0006/0000500008@1/0240200S00P0
8`1/0240K00U000030000000080U0000300000L0080X000030000040000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<0000280000800008P0006/000050000
8P1/0280200T00P0901/0280K00U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<000000000000000
ooooooooool500008`1/02<0200S00P08`1/02<0K00U000030000000080U0000300000L0080X0000
30000040000R000030000?oooolV0000700000400000000000000000000U8Qh09@0000`000010000
>`0000P0000K0000400001X000080000=P000100000Q0000200005P0000X000000000000003ooooo
ooooo`<0000S02l08`120240K00f0000400001X0001/0000F00002P00000000000000?oooooooooo
0`0001P0AP0H02`06P0803`000080000@00001P0000H0000200002<0001/00009@0000`000070020
:00000`0000100008@0000P0000k0000200001/0000@00008`0000P0000f0000400002X000080000
F00002P00000000000000?oooooooooo0`0002H0;P0V0480:P1/03H0000@00008`0006`0001H0000
:000000000000000ooooooooool300009@1B02D0900S00P0?00000P000130000300000D0000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<00002<000080000
900006/0000500008`1/02<0200T00P0901/02<0K00U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<00002<0000800009@0006/0000500008`1/02<0200U00P09@1/02<0K00U000030000000080U0000
300000L0080X000030000040000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<00002@0000800009P0006/000050000901/02@0200V00P09P1/02@0K00U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<00002D0000800009`0006/0000500009@1/02D0200W00P0
9`1/02D0K00U000030000000080U0000300000L0080X000030000040000W00006000004000000000
`/710000000U000030000040000U0000300000P0081F0000<00002H000080000:00006/000050000
9P1/02H0200X00P0:01/02H0K00U000030000000080U0000300000L0080X000030000040000W0000
6000004000000000`/710000000U000030000040000U0000300000P0081F0000<00002L000080000
:@0006/0000500009`1/02L0200Y00P0:@1/02L0K00U000030000000080U0000300000L0080X0000
30000040000W00006000004000000000`/710000000U000030000040000U0000300000P0081F0000
<00002P000080000:@0006/000050000:01/02P0200Z00P0:P1/02P0K00U000030000000080U0000
300000L0080X000030000040000W00006000004000000000`/710000000U000030000040000U0000
300000P0081F0000<00002T000080000:@0006/000050000:@1/02T0200[00P0:`1/02T0K00U0000
30000000080U0000300000L0080X000030000040000W00006000004000000000`/710000000U0000
30000040000U0000300000P0081F0000<000000000000000ooooooooool50000:P1/02X0200Z00P0
:P1/02X0K00U000030000000080U0000300000L0080X000030000040000R000030000?oooolV0000
700000400000000000000000000U8Qh09@0000`000010000>`0000P0000K0000400002<000080000
=P000100000Z0000200005P0000X000000000000003oooooooooo`<0000V02h09P1202X0K00f0000
400002<0001/0000F00002P00000000000000?oooooooooo0`0002D0DP0U02@08`0803`000080000
@00001P0000S0000200002X0001/00009@0000`000070020:00000`0000100009P0001`000010000
00000000000000009B8N02D0000<00000@0003/0000800006`000100000I00001`0003H0000@0000
7@0000L0000l000020000400000H00006@0000L0000M00001`0002D0000<00001`00P2P0000<0000
0@0002L0000H00000@000000000U8Qh0000002D0000<00000@0002D0000<00002000P1<0000<0000
0P0001<0000<00000P0005H0000d00006P000040000L00001`0000H0000K00406P0101X01`0L00L0
700101/00@0C000030000080000C000030000040000U000030000000080U0000300000L0080X0000
30000040000W000060000040000000009B8N0000000U000030000040000U0000300000P0080C0000
30000080000C000030000080001F0000=00001T0001^00006`0007@0000600006P1^01T0KP0I07@0
6`1d01/0KP0J06h04`0000`0000200004`0000`0000100009@0000`0000000209@0000`000070020
:00000`0000100003P0001@000000000400001@0
\>"], "Text",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.677337437902197*^9},
 ImageSize->{437.625, 196.563},
 ImageMargins->{{40, 0}, {0, 0}}],

Cell[TextData[{
 "As usual, when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", " "}], TraditionalForm]]],
 "is afocal, the aberration coefficients of the whole combination are \
obtained by adding the coefficients of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ", with the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " at a distance \[Dash]\[Delta]",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 ", and the coefficients of the doublet situated at ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 ". For the mirror S, we have (the variables f, \[Delta], r, x, \[Theta], \
\[Lambda] have to be unassigned, for that we use Clear)"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "\[Delta]", ",", "r", ",", "x", ",", "\[Theta]", ",", 
    "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"DS1", "=", "GOSphericalCoefficient"}]], "Input",
 CellChangeTimes->{{3.414897329375*^9, 3.41489734915625*^9}, {
  3.4148974720625*^9, 3.414897504328125*^9}, {3.677337456242223*^9, 
  3.677337530455327*^9}}],

Cell[BoxData[
 RowBox[{"DS2", "=", "GOComaCoefficient"}]], "Input",
 CellChangeTimes->{{3.414897329375*^9, 3.41489734915625*^9}, {
  3.4148974720625*^9, 3.414897504328125*^9}, {3.677337456242223*^9, 
  3.6773375517153563`*^9}}],

Cell[BoxData[
 RowBox[{"DS3", "=", "GOAstigmatismCoefficient"}]], "Input",
 CellChangeTimes->{{3.414897329375*^9, 3.41489734915625*^9}, {
  3.4148974720625*^9, 3.414897504328125*^9}, {3.677337456242223*^9, 
  3.6773375039752893`*^9}, {3.677337557175364*^9, 3.6773375632553725`*^9}}],

Cell[TextData[{
 "We evaluate the aberrations of Hougthon's corrector ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " in two cases:"
}], "Text",
 CellChangeTimes->{
  3.394606692875*^9, {3.414897370921875*^9, 3.41489737296875*^9}, {
   3.414897560015625*^9, 3.4148975614375*^9}, {3.437541502984375*^9, 
   3.43754151540625*^9}, {3.43754558896875*^9, 3.43754563840625*^9}, 
   3.438916069609375*^9, {3.438916099828125*^9, 3.438916117734375*^9}, {
   3.438916168734375*^9, 3.438916170828125*^9}, 3.677337592585414*^9},
 FontSize->18],

Cell[TextData[{
 "1) The two thin lenses of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " have curvatures ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], ",", " ", 
    SubscriptBox["c", "2"], ",", " ", 
    RowBox[{"-", 
     SubscriptBox["c", "1"]}], ",", " ", 
    RowBox[{"-", 
     SubscriptBox["c", "2"]}]}], TraditionalForm]]],
 " (it is plain to verify that this system is afocal);"
}], "Text",
 CellChangeTimes->{
  3.394606692875*^9, {3.414897370921875*^9, 3.41489737296875*^9}, {
   3.414897560015625*^9, 3.4148975614375*^9}, {3.437541502984375*^9, 
   3.43754151540625*^9}, {3.43754558896875*^9, 3.43754563840625*^9}, 
   3.438916069609375*^9, {3.438916099828125*^9, 3.438916117734375*^9}, {
   3.438916168734375*^9, 3.438916170828125*^9}, {3.677337592845414*^9, 
   3.6773375975054207`*^9}},
 FontSize->18],

Cell[TextData[{
 "2) the curatures are different but still verify the condition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["c", "1"], "-", 
     SubscriptBox["c", "2"], "+", 
     SubscriptBox["c", "3"], "-", 
     SubscriptBox["c", "4"]}], "=", "0"}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{
  3.394606692875*^9, {3.414897370921875*^9, 3.41489737296875*^9}, {
   3.414897560015625*^9, 3.4148975614375*^9}, {3.437541502984375*^9, 
   3.43754151540625*^9}, {3.43754558896875*^9, 3.43754563840625*^9}, 
   3.438916069609375*^9, {3.438916099828125*^9, 3.438916117734375*^9}, {
   3.438916168734375*^9, 3.438916170828125*^9}, {3.677337592845414*^9, 
   3.677337616445447*^9}},
 FontSize->18],

Cell[TextData[{
 "in order to have an afocal corrector ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " (see Chapter 6). With respect to the first possibility, we have"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", "c2", ",", "Ni", ",", "\[Theta]", ",", "x", ",", "\[Lambda]"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", 
      RowBox[{"1", "/", "c2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c1"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c2"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ni", ",", "1", ",", "Ni", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"DC11", "=", 
  RowBox[{"GOSphericalCoefficient", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DC12", "=", 
  RowBox[{"GOComaCoefficient", "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"DC13", "=", 
  RowBox[{"GOAstigmatismCoefficient", "//", "Simplify"}]}]], "Input"],

Cell["Spherical aberration and coma vanish when", "Text",
 CellChangeTimes->{{3.414897987875*^9, 3.414897999515625*^9}, {
   3.414898031609375*^9, 3.414898053140625*^9}, 3.437541529640625*^9, {
   3.43754566971875*^9, 3.437545670875*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"DS1", "+", "DC11"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"DS2", "+", "DC12"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c1", ",", "c2"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4148976415625*^9, 3.41489772375*^9}, {
  3.414898176390625*^9, 3.414898181921875*^9}, {3.6773376640455136`*^9, 
  3.6773376663155165`*^9}, {3.6773377377156167`*^9, 3.677337739385619*^9}}],

Cell["\<\
Taking into account the expressions of DS1 and DS2, the following relations \
are derived\
\>", "Text",
 CellChangeTimes->{{3.414897987875*^9, 3.414897999515625*^9}, 
   3.414898065796875*^9, 3.437541535703125*^9, {3.437545684203125*^9, 
   3.43754569575*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DS1", "=", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"32", " ", 
      SuperscriptBox["f", "3"]}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DS2", "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Delta]"}], 
     RowBox[{"8", " ", 
      SuperscriptBox["f", "2"]}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DS3", "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}]}], 
    RowBox[{"8", " ", "f"}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.41489749940625*^9, 3.414897507109375*^9}, 
   3.414897804078125*^9, 3.41489784375*^9, {3.414898101265625*^9, 
   3.414898214296875*^9}, {3.677337691365552*^9, 3.6773377188055906`*^9}}],

Cell[BoxData[
 RowBox[{"R1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"1", "/", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{"c1", ",", "sol"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.41489749940625*^9, 3.414897507109375*^9}, 
   3.414897804078125*^9, 3.41489784375*^9, {3.414898101265625*^9, 
   3.414898214296875*^9}, {3.677337691365552*^9, 3.6773377188055906`*^9}}],

Cell[BoxData[
 RowBox[{"R2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"1", "/", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{"c2", ",", "sol"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.41489749940625*^9, 3.414897507109375*^9}, 
   3.414897804078125*^9, 3.41489784375*^9, {3.414898101265625*^9, 
   3.414898214296875*^9}, {3.677337691365552*^9, 3.6773376989555626`*^9}, {
   3.677337767425658*^9, 3.6773377762956705`*^9}}],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "7"}], "+", 
     RowBox[{"12", "\[Delta]"}], "-", 
     RowBox[{"6", 
      SuperscriptBox["\[Delta]", "2"]}], "+", 
     SuperscriptBox["\[Delta]", "3"]}], "=", 
    RowBox[{
     RowBox[{"1", "-", "8", "+", 
      RowBox[{"12", "\[Delta]"}], "-", 
      RowBox[{"6", 
       SuperscriptBox["\[Delta]", "2"]}], "+", 
      SuperscriptBox["\[Delta]", "3"]}], "=", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Delta]", "-", "2"}], ")"}], "3"]}]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "9"}], "+", 
     RowBox[{"12", "\[Delta]"}], "-", 
     RowBox[{"6", 
      SuperscriptBox["\[Delta]", "2"]}], "+", 
     SuperscriptBox["\[Delta]", "3"]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "8", "+", 
      RowBox[{"12", "\[Delta]"}], "-", 
      RowBox[{"6", 
       SuperscriptBox["\[Delta]", "2"]}], "+", 
      SuperscriptBox["\[Delta]", "3"]}], "=", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Delta]", "-", "2"}], ")"}], "3"]}]}]}], TraditionalForm]]],
 " we can also write"
}], "Text",
 CellChangeTimes->{{3.414897987875*^9, 3.414897999515625*^9}, 
   3.414898065796875*^9, {3.414899229625*^9, 3.414899395875*^9}, 
   3.437541567*^9},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"R1", "=", 
   RowBox[{"f", 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "+", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.41489942684375*^9, 3.4148994470625*^9}, 
   3.4148995864375*^9, {3.43754609309375*^9, 3.437546094015625*^9}, 
   3.43891632028125*^9, 3.677337790395691*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{
    RowBox[{"-", "f"}], 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "-", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.41489942684375*^9, 3.4148994470625*^9}, 
   3.4148995864375*^9, {3.43754609309375*^9, 3.437546094015625*^9}, 
   3.43891632028125*^9, {3.677337790395691*^9, 3.6773377975057006`*^9}}],

Cell[TextData[{
 "In order to understand the behavior of ",
 Cell[BoxData[
  FormBox["R1", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["R2", TraditionalForm]]],
 " versus \[Delta], we consider the plots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r1", "=", 
    RowBox[{"R1", "/", "f"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r2", "="}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"R2", "/", "f"}], TraditionalForm]]],
 " versus \[Delta], for BK7 (Ni = 1.5187228 ):"
}], "Text",
 CellChangeTimes->{{3.3946067554375*^9, 3.394606763375*^9}, {
   3.414899470640625*^9, 3.414899510125*^9}, {3.414899583328125*^9, 
   3.41489959284375*^9}, 3.414899654671875*^9, 3.43754157665625*^9, {
   3.43891636528125*^9, 3.43891638896875*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"4", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Ni", "+", "1"}], ")"}], "+", 
        RowBox[{"Ni", 
         RowBox[{"(", 
          RowBox[{"Ni", "-", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]], ")"}], ",", 
     RowBox[{"Ni", "->", "1.5187228"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.414899640359375*^9, 3.414899647046875*^9}, {
  3.6773378095157175`*^9, 3.677337823575737*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Ni", "+", "1"}], ")"}], "-", 
         RowBox[{"Ni", 
          RowBox[{"(", 
           RowBox[{"Ni", "-", "1"}], ")"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}], ")"}], ",", 
     RowBox[{"Ni", "->", "1.5187228"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.414899640359375*^9, 3.414899647046875*^9}, {
  3.6773378095157175`*^9, 3.6773378475357704`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.7", ",", "3.3"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Delta]\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414899640359375*^9, 3.414899647046875*^9}, {
  3.6773378095157175`*^9, 3.6773378681157994`*^9}}],

Cell[TextData[{
 "The above plot shows that the best values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 ", i. e. the greatest absolute values which reduce higher-order aberrations, \
are obtained either for \[Delta] \[Epsilon] [0.7, 1.1] or for \[Delta] \
\[Epsilon] [2.8, 3.2]. However, a very long tube corresponds to these last \
values.\nThese results are valid when the thickness of the lenses can be \
neglected."
}], "Text",
 CellChangeTimes->{{3.394606802953125*^9, 3.394606851328125*^9}, {
  3.43754159490625*^9, 3.437541641296875*^9}, {3.43754576728125*^9, 
  3.437545794171875*^9}, {3.677337885255823*^9, 3.677337885755824*^9}},
 FontSize->18],

Cell["\<\
If the curvature radii are different, we have to consider the following \
system:\
\>", "Text",
 CellChangeTimes->{{3.437541649046875*^9, 3.437541649734375*^9}, {
  3.438916425046875*^9, 3.43891643640625*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", "c2", ",", "Ni", ",", "\[Theta]", ",", "x", ",", "\[Lambda]"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", 
      RowBox[{"1", "/", "c2"}], ",", 
      RowBox[{"1", "/", "c3"}], ",", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c1", "-", "c2", "+", "c3"}], ")"}]}]}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ni", ",", "1", ",", "Ni", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell["\<\
Where the aberration coefficient are given by the following output variables\
\>", "Text",
 CellChangeTimes->{{3.6773379324258895`*^9, 3.6773379400158997`*^9}, {
  3.677338901347246*^9, 3.6773389088972564`*^9}}],

Cell[BoxData["GOSphericalCoefficient"], "Input",
 CellChangeTimes->{{3.6773379895659695`*^9, 3.6773379964559793`*^9}}],

Cell[BoxData["GOComaCoefficient"], "Input",
 CellChangeTimes->{{3.6773380199360123`*^9, 3.677338022116015*^9}}],

Cell[BoxData["GOAstigmatismCoefficient"], "Input",
 CellChangeTimes->{{3.6773380239960175`*^9, 3.67733802572602*^9}}],

Cell["\<\
To put DC1 in a more convenient form, we note that the factor\
\>", "Text",
 CellChangeTimes->{{3.43754165625*^9, 3.43754167809375*^9}, 
   3.6773380487360525`*^9},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", "Ni"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "Ni"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "c3"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "Ni"}], ")"}]}], "-", 
      RowBox[{"2", " ", "c2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["Ni", "2"]}], ")"}]}], "+", 
      RowBox[{"c1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", "Ni", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["Ni", "2"]}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "DisplayFormula",
 CellChangeTimes->{{3.43754165625*^9, 3.43754167809375*^9}, {
  3.6773380496460533`*^9, 3.677338050846055*^9}, {3.677338437056596*^9, 
  3.677338444666607*^9}}],

Cell["becomes", "Text",
 CellChangeTimes->{{3.43754165625*^9, 3.43754167809375*^9}, 
   3.6773380496460533`*^9},
 FontSize->18],

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", "Ni"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c3"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "Ni"}], ")"}]}], "-", 
         RowBox[{"2", " ", "c2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["Ni", "2"]}], ")"}]}], "+", 
         RowBox[{"c1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "-", "Ni", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["Ni", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], 
    "]"}], "]"}], "]"}]], "Input"],

Cell[TextData[{
 "Spherical aberration and coma coefficients of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " write:"
}], "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338059136067*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{"D1C", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "2"], "-", 
      SubscriptBox["c", "3"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "1"], "-", 
      SubscriptBox["c", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{"Ni", "+", "1"}], ")"}], "8"]}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", 
          SubscriptBox["c", "1"]}], "-", 
         RowBox[{"2", 
          SubscriptBox["c", "2"]}], "+", 
         SubscriptBox["c", "3"]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4", "Ni"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          SubscriptBox["c", "1"]}], "-", 
         SubscriptBox["c", "2"], "+", 
         SubscriptBox["c", "3"]}], ")"}]}], "+", 
      RowBox[{
       FractionBox[
        SuperscriptBox["Ni", "2"], "4"], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["c", "1"], "-", 
         SubscriptBox["c", "2"]}], ")"}]}]}], ")"}]}],
   TraditionalForm]}]], "DisplayFormula",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338069226081*^9}, {3.6773384273265824`*^9, 3.6773384273265824`*^9}}],

Cell[BoxData[
 RowBox[{"D2C", " ", "=", " ", 
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], 
      RowBox[{"2", "Ni"}]]}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "1"], "-", 
      SubscriptBox["c", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "2"], "-", 
      SubscriptBox["c", "3"]}], ")"}]}],
   TraditionalForm]}]], "DisplayFormula",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.6773380724160852`*^9}, {3.6773384273265824`*^9, 3.6773384273265824`*^9}}],

Cell["The curvature radii", "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338074546088*^9}},
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["R", "1"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "1"]]}], ",", " ", 
   RowBox[{
    SubscriptBox["R", "2"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "2"]]}], ",", " ", 
   RowBox[{
    SubscriptBox["R", "3"], "=", 
    FractionBox["1", 
     SubscriptBox["c", "3"]]}], ",", " ", 
   RowBox[{
    SubscriptBox["R", "4"], "=", 
    FractionBox["1", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["c", "1"], "-", 
       SubscriptBox["c", "2"], "+", 
       SubscriptBox["c", "3"]}], ")"}]]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.6773380781760936`*^9}, {3.67733838979653*^9, 3.677338419156571*^9}}],

Cell[TextData[{
 "of the two lenses of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", which eliminate spherical aberration and coma verify the system"
}], "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338080686097*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D1S", " ", "+", " ", "D1C"}], " ", "=", " ", "0"}], 
  ","}]], "DisplayFormula",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338084056102*^9}, {3.6773383816165185`*^9, 3.6773383816165185`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"D2S", " ", "+", " ", "D2C"}], " ", "=", " ", 
  "0."}]], "DisplayFormula",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338087916107*^9}, {3.6773383816165185`*^9, 3.6773383816165185`*^9}}],

Cell["\<\
In the book this system is proved to be equivalent to the following \
2nd-degree system\
\>", "Text",
 FontSize->18],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], "x"}], "+", 
     RowBox[{
      SubscriptBox["a", "2"], "y"}]}], "=", 
    SubscriptBox["d", "1"]}], ",", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}]}], "=", 
    SubscriptBox["d", "2"]}], ","}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338091206112*^9}},
 FontSize->18],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "1"], "/", 
       SubscriptBox["c", "3"]}], "=", 
      RowBox[{
       SubscriptBox["R", "3"], "/", 
       SubscriptBox["R", "1"]}]}]}], ",", " ", 
    RowBox[{"y", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "2"], "/", 
       SubscriptBox["c", "3"]}], "=", 
      RowBox[{
       SubscriptBox["R", "3"], "/", 
       SubscriptBox["R", "2"]}]}]}]}], TraditionalForm]]],
 " and "
}], "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.6773380938361154`*^9}},
 FontSize->18],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["a", "1"], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", "Ni"}]], 
    RowBox[{"(", 
     RowBox[{"4", "-", 
      RowBox[{"3", "Ni"}], "-", 
      RowBox[{"3", 
       SuperscriptBox["Ni", "2"]}], "+", 
      RowBox[{"2", 
       SuperscriptBox["Ni", "3"]}]}], ")"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["a", "2"], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", "Ni"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "Ni", "+", 
      SuperscriptBox["Ni", "2"], "-", 
      SuperscriptBox["Ni", "3"]}], ")"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["d", "1"], "=", 
   RowBox[{
    FractionBox["1", "8"], "-", 
    FractionBox["1", 
     RowBox[{"4", "Ni"}]], "+", 
    FractionBox["Ni", "8"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      SubscriptBox["R", "3"], "DS1"}], 
     RowBox[{"2", "Ni", " ", "DS2"}]]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["d", "2"], "=", 
   FractionBox[
    RowBox[{"2", 
     SuperscriptBox[
      SubscriptBox["NiR", "3"], "2"], "DS2"}], 
    RowBox[{
     SuperscriptBox["Ni", "2"], "-", "1"}]]}], 
  TraditionalForm]}], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.677338150666195*^9}}],

Cell["It remains to solve the system:", "Text",
 CellChangeTimes->{{3.43754173825*^9, 3.43754175671875*^9}, 
   3.43754585034375*^9, {3.438916459890625*^9, 3.438916468703125*^9}, {
   3.43891649921875*^9, 3.43891650303125*^9}, {3.6773380587660666`*^9, 
   3.6773381107561393`*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a1", " ", "x"}], "+", 
     RowBox[{"a2", " ", "y"}]}], "\[Equal]", "d1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}]}], "\[Equal]", "d2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{3.6773382311063075`*^9}],

Cell["Finally, recalling that", "Text",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, 3.6773382344363127`*^9},
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"x", "=", 
    RowBox[{
     FractionBox[
      SubscriptBox["c", "1"], 
      SubscriptBox["c", "3"]], "=", 
     FractionBox[
      SubscriptBox["R", "3"], 
      SubscriptBox["R", "1"]]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{
     FractionBox[
      SubscriptBox["c", "2"], 
      SubscriptBox["c", "3"]], "=", 
     FractionBox[
      SubscriptBox["R", "3"], 
      SubscriptBox["R", "2"]]}]}]}], TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.677338246236329*^9, 3.677338293116394*^9}, {
  3.677338339286459*^9, 3.6773383398464603`*^9}}],

Cell["and introducing the nondimensional radii", "Text",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.67733831107642*^9},
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    FractionBox[
     SubscriptBox["R", "1"], "f"]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", 
    FractionBox[
     SubscriptBox["R", "2"], "f"]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "3"], "=", 
    FractionBox[
     SubscriptBox["R", "3"], "f"]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "4"], "=", 
    FractionBox[
     SubscriptBox["R", "4"], "f"]}], ","}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.677338246236329*^9, 3.6773383676064987`*^9}}],

Cell["we obtain the following two solutions:", "Text",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.6773383114064198`*^9, {3.677338369656502*^9, 
   3.677338372546506*^9}},
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["r", "3"]}], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         RowBox[{"2", 
          SubscriptBox["d", "1"]}]}], ")"}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", "    ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "+", 
       SqrtBox["\[CapitalDelta]"]}]]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.6773383114064198`*^9, {3.677338369656502*^9, 
   3.6773383734465065`*^9}, {3.677338471216644*^9, 3.6773384867966657`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SubscriptBox["a", "1"], "(", 
         RowBox[{
          SubscriptBox["a", "2"], "-", 
          RowBox[{"2", 
           SubscriptBox["d", "1"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["a", "2"]}], "+", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "-", 
       SqrtBox["\[CapitalDelta]"]}]], "  "}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.6773383114064198`*^9, {3.677338369656502*^9, 
   3.6773383734465065`*^9}, {3.677338471216644*^9, 3.6773385131667023`*^9}}],

Cell["where", "Text",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.6773383114064198`*^9, {3.677338369656502*^9, 
   3.6773383734465065`*^9}, {3.677338471216644*^9, 3.677338516826708*^9}},
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalDelta]", " ", "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"]}], ")"}], "2"], "-", 
    RowBox[{"4", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["d", "1"], "+", 
       RowBox[{
        SubscriptBox["a", "1"], 
        SubscriptBox["d", "2"]}]}], ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.3946071775*^9, 3.394607180390625*^9}, {
   3.438916523453125*^9, 3.438916525265625*^9}, {3.677338234756313*^9, 
   3.6773382362663145`*^9}, 3.6773383114064198`*^9, {3.677338369656502*^9, 
   3.6773383734465065`*^9}, {3.677338471216644*^9, 3.677338531456728*^9}}],

Cell[TextData[{
 "These solutions are real if \[CapitalDelta]",
 Cell[BoxData[
  FormBox[
   RowBox[{">", "0"}], TraditionalForm]]],
 ". Owing to (2), the radii (3)-(4) and \[CapitalDelta], are functions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "3"], "  ", "and", "  ", Cell["\[Delta]."]}], 
   TraditionalForm]]],
 "To find the region of the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["r", "3"], ",", " ", "\[Delta]"}], ")"}], TraditionalForm]]],
 " in which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", ">", "0"}], TraditionalForm]]],
 ", for the glass BK7 (Ni = 1.5187228, in green light), it is sufficient to \
use the command RegionPlot of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sost", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a1", "->", 
       FractionBox[
        RowBox[{"4", "-", 
         RowBox[{"3", " ", "Ni"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["Ni", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["Ni", "3"]}]}], 
        RowBox[{"8", " ", "Ni"}]]}], ",", 
      RowBox[{"a2", "->", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni", "+", 
         SuperscriptBox["Ni", "2"], "-", 
         SuperscriptBox["Ni", "3"]}], 
        RowBox[{"4", " ", "Ni"}]]}], ",", 
      RowBox[{"d1", "->", 
       RowBox[{
        FractionBox["1", "8"], "-", 
        FractionBox["1", 
         RowBox[{"4", " ", "Ni"}]], "+", 
        FractionBox["Ni", "8"], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["Ni", "2"]}], ")"}], " ", "r3"}], 
         RowBox[{"8", " ", "Ni", " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", "\[Delta]"}], ")"}]}]]}]}], ",", 
      RowBox[{"d2", "->", 
       RowBox[{
        FractionBox["Ni", 
         RowBox[{"4", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Ni", "2"], "-", "1"}], ")"}]}]], 
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "*", 
        SuperscriptBox["r3", "2"]}]}]}], "}"}], "/.", 
    RowBox[{"Ni", "->", "1.5187228"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a1", "+", "a2", "+", "d1"}], ")"}], "2"], "-", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"a1", "+", "a2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"d1", "+", 
         RowBox[{"a1", " ", "d2"}]}], ")"}]}]}], ")"}], "/.", "sost"}]}], 
  ";"}], "\n", 
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"\[CapitalDelta]", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.7", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.394607145765625*^9, 3.39460714734375*^9}, {
   3.39460719084375*^9, 3.394607191296875*^9}, 3.6773387036669693`*^9}],

Cell[TextData[{
 "It is very important to recognize the behaviour of the radii (1)-(2) on \
varying ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 " in the interval of its acceptable values for any fixed \[Delta].\nThe \
analysis of the plots ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], ",", " ", 
    SubscriptBox["r", "2"]}], TraditionalForm]]],
 " versus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 ", corresponding to both solutions, shows that their more convenient values, \
for a fixed \[Delta], are obtained when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "\[Element]", 
    RowBox[{"(", 
     RowBox[{"0.7", ",", "1.1"}], ")"}], " "}], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 " coincides with the lower bound of the interval determined by the \
intersection of the stright line \[Delta] = const with the region on the \
right-hand side of the above figure."
}], "Text",
 CellChangeTimes->{{3.43754589975*^9, 3.437545915203125*^9}, {
  3.4389165590625*^9, 3.438916559734375*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r11", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "r3"}], 
      FractionBox[
       RowBox[{"2", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", 
           RowBox[{"2", " ", "d1"}]}], ")"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", "d1", "+", 
           SqrtBox["\[CapitalDelta]"]}], ")"}]}]}]]}], ")"}], "/.", 
    "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r21", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", " ", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{"a1", "+", "a2", "+", "d1", "+", 
        SqrtBox["\[CapitalDelta]"]}]]}], ")"}], "/.", "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r41", "=", 
   FractionBox[
    RowBox[{"r11", " ", "r21", " ", "r3"}], 
    RowBox[{
     RowBox[{"r21", " ", "r3"}], "-", 
     RowBox[{"r11", " ", "r3"}], "+", 
     RowBox[{"r11", " ", "r21"}]}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.43754593971875*^9, 3.67733886126719*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r11", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r21", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r41", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "1.61"}], ",", 
     RowBox[{"-", "1.45"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".01", "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.43754593971875*^9, {3.67733886126719*^9, 3.677338864447194*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r11", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
      RowBox[{"r21", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
      RowBox[{"r41", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r3", ",", 
      RowBox[{"-", "1.52"}], ",", 
      RowBox[{"-", "1.48"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", ".03", "}"}], "]"}], ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", ".01", "}"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5"}], ",", "15"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \(2\
\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{
  3.43754593971875*^9, {3.67733886126719*^9, 3.677338864447194*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r12", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", 
      FractionBox[
       RowBox[{"2", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a1"}], " ", 
         RowBox[{"(", 
          RowBox[{"a2", "-", 
           RowBox[{"2", " ", "d1"}]}], ")"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a2"}], "+", "d1", "+", 
           SqrtBox["\[CapitalDelta]"]}], ")"}]}]}]]}], ")"}], "/.", 
    "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r22", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r3", " ", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a1", "+", "a2"}], ")"}]}], 
       RowBox[{"a1", "+", "a2", "+", "d1", "-", 
        SqrtBox["\[CapitalDelta]"]}]]}], ")"}], "/.", "sost"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r42", "=", 
   FractionBox[
    RowBox[{"r12", " ", "r22", " ", "r3"}], 
    RowBox[{
     RowBox[{"r22", " ", "r3"}], "-", 
     RowBox[{"r12", " ", "r3"}], "+", 
     RowBox[{"r12", " ", "r22"}]}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.677338871927205*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r12", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r22", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}], ",", 
     RowBox[{"r42", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "0.8"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "1.61"}], ",", 
     RowBox[{"-", "1.58"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".01", "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6.5"}], ",", "3"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.677338871927205*^9, 3.677338874677209*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r12", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
     RowBox[{"r22", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}], ",", 
     RowBox[{"r42", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1.1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", 
     RowBox[{"-", "1.52"}], ",", 
     RowBox[{"-", "1.48"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".01", "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[
FormBox[
SubscriptBox[\"r\", \"3\"], TraditionalForm]]]]]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(r\), \(1\)]\), \!\(\*SubscriptBox[\(r\), \
\(2\)]\), \!\(\*SubscriptBox[\(r\), \(4\)]\)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.677338871927205*^9, 3.677338874677209*^9}}],

Cell[TextData[{
 "If we wish to control the astigmatism in the Houghton's combination, a \
conic mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " has to be used. In fact, to evaluate the aberrations of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ", with the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " at a distance \[Delta]f in front of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ", we consider the system"
}], "Text",
 CellChangeTimes->{
  3.437545964046875*^9, {3.438916587734375*^9, 3.438916588140625*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "K", ",", "r", ",", "\[Delta]", ",", "\[Theta]", ",", "x", ",", 
    "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "K", "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell["\<\
Where the aberration coefficient are given by the following output variables\
\>", "Text",
 CellChangeTimes->{{3.6773379324258895`*^9, 3.6773379400158997`*^9}, {
  3.677338901347246*^9, 3.6773389088972564`*^9}}],

Cell[BoxData[
 RowBox[{"DS1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.414135106234375*^9, 3.414135145328125*^9}, {
  3.43754597775*^9, 3.437546002765625*^9}, {3.677338890427231*^9, 
  3.6773388916772327`*^9}, {3.6773389700073423`*^9, 3.677338971827345*^9}}],

Cell[BoxData[
 RowBox[{"DS2", "=", 
  RowBox[{"Simplify", "[", "GOComaCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.414135106234375*^9, 3.414135145328125*^9}, {
  3.43754597775*^9, 3.437546002765625*^9}, {3.677338890427231*^9, 
  3.6773388916772327`*^9}, {3.6773389700073423`*^9, 3.6773389802573566`*^9}}],

Cell[BoxData[
 RowBox[{"DS3", "=", 
  RowBox[{"Simplify", "[", "GOAstigmatismCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.414135106234375*^9, 3.414135145328125*^9}, {
  3.43754597775*^9, 3.437546002765625*^9}, {3.677338890427231*^9, 
  3.6773388916772327`*^9}, {3.6773389700073423`*^9, 3.677338987837367*^9}}],

Cell["Consequently, the astigmatism vanishes when", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{"conic", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "-", 
       RowBox[{"4", " ", "\[Delta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "K"}], ")"}], " ", 
        SuperscriptBox["\[Delta]", "2"]}]}], "\[Equal]", "0"}], ",", "K"}], 
    "]"}], "//", "Simplify"}]}]], "Input"],

Cell[TextData[{
 "and the spherical aberration and coma coefficients of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " write:"
}], "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{"DS1f", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"DS1", "/.", "conic"}], "]"}]}]], "Input",
 CellChangeTimes->{3.6773389970973797`*^9}],

Cell[BoxData[
 RowBox[{"DS2f", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"DS2", "/.", "conic"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6773389970973797`*^9, 3.6773390060273924`*^9}}],

Cell["Substituting these expressions into (*), we obtain:", "Text",
 CellChangeTimes->{{3.437546122390625*^9, 3.437546124453125*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{"R1", "=", 
  RowBox[{"-", 
   RowBox[{"Simplify", "[", 
    FractionBox[
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1f", " ", "DS2f"}], 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["DS1f", "2"], 
       RowBox[{"(", 
        RowBox[{"Ni", "+", "1"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["DS2f", "3"], " ", "Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}]}]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{3.6773390105073986`*^9}],

Cell[BoxData[
 RowBox[{"R2", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], "DS1f", " ", "DS2f"}], 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["DS1f", "2"], 
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["DS2f", "3"], " ", "Ni", 
      RowBox[{"(", 
       RowBox[{"Ni", "-", "1"}], ")"}]}]}]], "]"}]}]], "Input",
 CellChangeTimes->{3.6773390105073986`*^9}],

Cell["so that we obtain the relations:", "Text",
 CellChangeTimes->{{3.437546134234375*^9, 3.43754614434375*^9}, 
   3.677339021907415*^9},
 FontSize->18],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"K", " ", "=", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "2"], 
      SuperscriptBox["\[Delta]", "2"]]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["R", "1"], "=", 
    FractionBox[
     RowBox[{"4", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["Ni", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
       "\[Delta]"}], "-", 
      RowBox[{"Ni", " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"12", " ", "\[Delta]"}], "+", 
         RowBox[{"14", " ", 
          SuperscriptBox["\[Delta]", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["\[Delta]", "3"]}], "+", 
         SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]]}]}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["R", "2"], "=", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["Ni", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
       "\[Delta]"}], "+", 
      RowBox[{"Ni", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"4", " ", "\[Delta]"}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["\[Delta]", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["\[Delta]", "3"]}], "-", 
         SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]], "."}]}], 
  TraditionalForm]}], "DisplayFormula",
 CellChangeTimes->{{3.437546134234375*^9, 3.43754614434375*^9}, {
  3.6773390222374153`*^9, 3.6773390323474293`*^9}}],

Cell[TextData[{
 "Introducing the nondimensional radii ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["r", "1"], "=", 
     RowBox[{
      SubscriptBox["R", "1"], "/", "f"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["r", "2"], "=", 
     RowBox[{
      SubscriptBox["R", "2"], "/", "f"}]}]}], TraditionalForm]]],
 " and resorting to the plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["r", "1"], ",", " ", 
     SubscriptBox["r", "2"], ",", " ", "K"}], ")"}], TraditionalForm]]],
 " versus \[Delta], the behavior of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", ",", " ", 
    SubscriptBox["r", "1"], ",", "  ", 
    RowBox[{"and", "  ", 
     SubscriptBox["r", "2"]}]}], TraditionalForm]]],
 " on varying \[Delta] can be recognized "
}], "Text",
 CellChangeTimes->{{3.438916627109375*^9, 3.438916627109375*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"K", "=", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Delta]", "-", "2"}], ")"}], "2"], 
     SuperscriptBox["\[Delta]", "2"]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["Ni", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
       "\[Delta]"}], "-", 
      RowBox[{"Ni", " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"12", " ", "\[Delta]"}], "+", 
         RowBox[{"14", " ", 
          SuperscriptBox["\[Delta]", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["\[Delta]", "3"]}], "+", 
         SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]], "/.", 
    RowBox[{"Ni", "->", "1.5187228"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["Ni", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
       "\[Delta]"}], "+", 
      RowBox[{"Ni", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"4", " ", "\[Delta]"}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["\[Delta]", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["\[Delta]", "3"]}], "-", 
         SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]], "/.", 
    RowBox[{"Ni", "->", "1.5187228"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{3.6773390423474436`*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2", ",", "K"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.4", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", ".03", "}"}], "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"{", "0.01", "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Delta]\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(r\), \(1\)]\),\!\(\*SubscriptBox[\(r\), \
\(2\)]\),K) \>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6773390423474436`*^9, 3.6773390501074543`*^9}}],

Cell["The more convenient values are obtained for \[Delta] \[Epsilon] [1.2, \
1.4].", "Text",
 FontSize->18]
}, Open  ]],

Cell[CellGroupData[{

Cell["Houghton Camera summary of main functions", "Title"],

Cell["\<\
Houghton\[CloseCurlyQuote]s camera with symmetric doublet (no control of \
astigmatism)\
\>", "Text",
 CellChangeTimes->{
  3.6773391039275293`*^9, {3.6773469536596823`*^9, 3.677346961099693*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["R", "1"], "=", 
   RowBox[{"f", 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "+", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], "3"]}]}]]}]}], ",", 
  "          ", "\n", 
  RowBox[{
   SubscriptBox["R", "2"], "=", 
   RowBox[{
    RowBox[{"-", "f"}], 
    FractionBox[
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Ni", "2"], "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"2", "-", "\[Delta]"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Ni", "+", "1"}], ")"}], "-", 
      RowBox[{"Ni", 
       RowBox[{"(", 
        RowBox[{"Ni", "-", "1"}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "-", "\[Delta]"}], ")"}], 
        "3"]}]}]]}]}]}]], "DisplayFormula",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339126507561*^9}}],

Cell["\<\
\[Delta] \[Epsilon] [0.75, 1.1]. This is a good combination for speed less \
than F/3.5.\
\>", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339133837571*^9}}],

Cell["\<\
Houghton\[CloseCurlyQuote]s camera with doublet with different radii (no \
control of astigmatism)\
\>", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.6773391375175767`*^9}, {
  3.6773469707697067`*^9, 3.6773469721797085`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["r", "3"]}], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         RowBox[{"2", 
          SubscriptBox["d", "1"]}]}], ")"}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         SubscriptBox["a", "2"], "-", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", "    ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "+", 
       SqrtBox["\[CapitalDelta]"]}]]}]}], ","}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.6773391617376103`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{
        SubscriptBox["a", "1"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SubscriptBox["a", "1"], "(", 
         RowBox[{
          SubscriptBox["a", "2"], "-", 
          RowBox[{"2", 
           SubscriptBox["d", "1"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["a", "2"], "(", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["a", "2"]}], "+", 
         SubscriptBox["d", "1"], "+", 
         SqrtBox["\[CapitalDelta]"]}], ")"}]}]]}]}], ",", " ", 
   RowBox[{
    SubscriptBox["r", "2"], "=", " ", 
    RowBox[{
     SubscriptBox["r", "3"], 
     FractionBox[
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["a", "1"], "+", 
         SubscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["a", "1"], "+", 
       SubscriptBox["a", "2"], "+", 
       SubscriptBox["d", "1"], "-", 
       SqrtBox["\[CapitalDelta]"]}]]}]}], ","}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.6773391862176447`*^9}}],

Cell["where", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.6773391897476497`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalDelta]", " ", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"], "+", 
        SubscriptBox["d", "1"]}], ")"}], "2"], "-", 
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], "+", 
        SubscriptBox["a", "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["d", "1"], "+", 
        RowBox[{
         SubscriptBox["a", "1"], 
         SubscriptBox["d", "2"]}]}], ")"}]}]}], ">", "0."}]}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339198637662*^9}}],

Cell["\<\
\[Delta] \[Epsilon] [0.8, 1.2]. This is a good combination for speed less \
than F/2.5.\
\>", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339204757671*^9}}],

Cell["Houghton\[CloseCurlyQuote]s camera with symmetric doublet and conic \
mirror ", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339207947675*^9}, {
  3.6773469744797115`*^9, 3.677346976989715*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"K", " ", "=", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "2"], 
      SuperscriptBox["\[Delta]", "2"]]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["R", "1"], "=", 
    FractionBox[
     RowBox[{"4", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["Ni", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
       "\[Delta]"}], "-", 
      RowBox[{"Ni", " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"12", " ", "\[Delta]"}], "+", 
         RowBox[{"14", " ", 
          SuperscriptBox["\[Delta]", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["\[Delta]", "3"]}], "+", 
         SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]]}], ",", "\n", 
   RowBox[{
    SubscriptBox["R", "2"], "=", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["Ni", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]"}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["Ni", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "\[Delta]"}], ")"}], "3"], " ", 
        "\[Delta]"}], "+", 
       RowBox[{"Ni", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"4", " ", "\[Delta]"}], "-", 
          RowBox[{"10", " ", 
           SuperscriptBox["\[Delta]", "2"]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["\[Delta]", "3"]}], "-", 
          SuperscriptBox["\[Delta]", "4"]}], ")"}]}]}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.677339215857686*^9}}],

Cell["\[Delta] \[Epsilon] [1.2, 1.4].", "Text",
 CellChangeTimes->{{3.6773391087575364`*^9, 3.6773392193776913`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HoughtonCamera examples (CameraType\[Rule]\[OpenCurlyDoubleQuote]SD\
\[CloseCurlyDoubleQuote], symmetrix doublet - no control of astigmatism)\
\>", "Title",
 CellChangeTimes->{{3.43874789515625*^9, 3.438747901515625*^9}, 
   3.677335772147626*^9, {3.6773390666674776`*^9, 3.6773390686274805`*^9}, {
   3.677346983859725*^9, 3.6773470093197603`*^9}, {3.677375731909972*^9, 
   3.6773757320899725`*^9}, {3.6773798293347087`*^9, 3.6773798535047426`*^9}}],

Cell["\<\
To use the HoughtonCamera function you can either use directly the function \
HoughtonCamera[f, spes, diam, \[CapitalDelta], Ni, \[Theta]] or use the \
interactive panel created by calling the function HoughtonCameraInputPanel[]. \
It let\[CloseCurlyQuote]s you to set input variables\[CloseCurlyQuote] values \
and then call the HoughtonCamera function. Moreover, it helps to load \
examples from the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Houghton's camera F/5 (working as Newtoniana telescope)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "1000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "2.5", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "850"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.6"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Houghton's camera F/4 (short tube)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "800"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3.2", ",", "7"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "600"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.414131749328125*^9, {3.4389168085625*^9, 3.438916820359375*^9}, {
   3.438917552984375*^9, 3.4389175541875*^9}, {3.6773797646546183`*^9, 
   3.677379767574622*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoughtonCamera", "[", 
   RowBox[{
   "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
    "\[Theta]"}], "]"}], "\n"}]], "Input",
 CellChangeTimes->{
  3.414131749328125*^9, {3.4389168085625*^9, 3.438916820359375*^9}, {
   3.438917552984375*^9, 3.4389175541875*^9}, {3.6773797646546183`*^9, 
   3.677379767574622*^9}}],

Cell["Houghton's camera F/4 (long tube)", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "800"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3.2", ",", "7"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\n", 
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]"}], "]"}], "\n"}], "Input",
 CellChangeTimes->{
  3.414132954484375*^9, {3.4389168379375*^9, 3.438916846984375*^9}, {
   3.43891756053125*^9, 3.43891756090625*^9}, 3.677379775154633*^9}],

Cell["Houghton's camera F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "600."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "2.5", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "750"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\n", 
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]"}], "]"}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HoughtonCamera examples (CameraType\[Rule]\[OpenCurlyDoubleQuote]DDR\
\[CloseCurlyDoubleQuote], doublet with different radii - no control of \
astigmatism)\
\>", "Title",
 CellChangeTimes->{{3.43874789515625*^9, 3.438747901515625*^9}, 
   3.677335772147626*^9, {3.6773390666674776`*^9, 3.6773390686274805`*^9}, {
   3.677346983859725*^9, 3.677347020369776*^9}, {3.6773798652547593`*^9, 
   3.677379881774782*^9}}],

Cell["Houghton's camera F/4", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "800."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "3", ",", "8"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.4"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.41413080421875*^9, {3.4389169600625*^9, 3.4389169711875*^9}, 
   3.438917005453125*^9, {3.43891726003125*^9, 3.4389172661875*^9}, {
   3.43891750359375*^9, 3.438917503859375*^9}, 3.6773771841150055`*^9, 
   3.67737857306995*^9}],

Cell[BoxData[
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f1", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]", ",", " ", 
   RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.677378434466756*^9, 3.677378460466792*^9}, {
  3.677378564199938*^9, 3.6773786308000307`*^9}, {3.6773800784250574`*^9, 
  3.677380083155064*^9}}],

Cell["Houghton's camera F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "600."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"15", ",", "5.5", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "750"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.42"}], ";"}], "\n", 
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]", ",", 
   RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.414130824640625*^9, 3.41413082809375*^9}, {
  3.43891724446875*^9, 3.438917246640625*^9}, {3.43891727678125*^9, 
  3.4389173016875*^9}, {3.43891749596875*^9, 3.43891749625*^9}, {
  3.6773801212151175`*^9, 3.677380126515125*^9}}],

Cell["Houghton's camera F/2.5", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "/", "2.5"}], ":", " ", 
     RowBox[{"long", " ", "tube", " ", "\[CapitalDelta]"}]}], " ", "=", " ", 
    "600"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "=", "500"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"spes", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "5", ",", "8"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"diam", "=", "200"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", "600"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "1.5"}], ";"}], "\n", 
   RowBox[{"HoughtonCamera", "[", 
    RowBox[{
    "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
     "\[Theta]", ",", 
     RowBox[{"CameraType", "\[Rule]", "\"\<DDR\>\""}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.41413083890625*^9, {3.4389173149375*^9, 3.438917336390625*^9}, {
   3.6773801312451315`*^9, 3.677380136205138*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HoughtonCamera examples (CameraType\[Rule]\[OpenCurlyDoubleQuote]SDCM\
\[CloseCurlyDoubleQuote], with symmetrix doublet and conic mirror)\
\>", "Title",
 CellChangeTimes->{{3.43874789515625*^9, 3.438747901515625*^9}, 
   3.677335772147626*^9, {3.6773390666674776`*^9, 3.6773390686274805`*^9}, {
   3.677346983859725*^9, 3.6773470402798033`*^9}, {3.6773799208548365`*^9, 
   3.6773799412048655`*^9}}],

Cell["Houghton's camera F/2.5", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "500."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "5.5", ",", "6"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "650"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "2"}], ";"}], "\n", 
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]", ",", " ", 
   RowBox[{"CameraType", "\[Rule]", "\"\<SDCM\>\""}]}], "]"}]}], "Input"],

Cell["Houghton's camera F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "600"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "6", ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "750"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5187228"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\n", 
 RowBox[{"HoughtonCamera", "[", 
  RowBox[{
  "f", ",", "spes", ",", "diam", ",", "\[CapitalDelta]", ",", "Ni", ",", 
   "\[Theta]", ",", " ", 
   RowBox[{"CameraType", "\[Rule]", "\"\<SDCM\>\""}]}], "]"}]}], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<HoughtonCamera\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"HoughtonCamera", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"HoughtonCameraInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 32, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[636, 26, 35, 0, 43, "Subsection"],
Cell[674, 28, 109, 2, 46, "Text"],
Cell[786, 32, 1657, 43, 303, "Text"],
Cell[2446, 77, 2682, 65, 561, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5165, 147, 40, 0, 43, "Subsection"],
Cell[5208, 149, 250, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5495, 160, 40, 0, 43, "Subsection"],
Cell[5538, 162, 111, 2, 46, "Text"],
Cell[5652, 166, 3193, 83, 551, "Text"],
Cell[8848, 251, 2296, 56, 473, "Text"],
Cell[11147, 309, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14661, 404, 44, 0, 71, "Title"],
Cell[14708, 406, 1094, 28, 70, "Text"],
Cell[15805, 436, 8590, 110, 222, "Text"],
Cell[24398, 548, 698, 21, 70, "Text"],
Cell[25099, 571, 962, 31, 143, "Input"],
Cell[26064, 604, 230, 4, 32, "Input"],
Cell[26297, 610, 227, 4, 32, "Input"],
Cell[26527, 616, 282, 4, 32, "Input"],
Cell[26812, 622, 539, 12, 46, "Text"],
Cell[27354, 636, 850, 23, 46, "Text"],
Cell[28207, 661, 727, 18, 50, "Text"],
Cell[28937, 681, 202, 6, 46, "Text"],
Cell[29142, 689, 1141, 36, 143, "Input"],
Cell[30286, 727, 104, 2, 32, "Input"],
Cell[30393, 731, 99, 2, 32, "Input"],
Cell[30495, 735, 106, 2, 32, "Input"],
Cell[30604, 739, 253, 4, 46, "Text"],
Cell[30860, 745, 594, 15, 32, "Input"],
Cell[31457, 762, 285, 7, 46, "Text"],
Cell[31745, 771, 900, 29, 137, "Input"],
Cell[32648, 802, 384, 8, 32, "Input"],
Cell[33035, 812, 436, 9, 32, "Input"],
Cell[33474, 823, 1440, 48, 46, "Text"],
Cell[34917, 873, 726, 22, 56, "Input"],
Cell[35646, 897, 772, 23, 56, "Input"],
Cell[36421, 922, 798, 25, 46, "Text"],
Cell[37222, 949, 802, 24, 56, "Input"],
Cell[38027, 975, 842, 25, 56, "Input"],
Cell[38872, 1002, 526, 14, 32, "Input"],
Cell[39401, 1018, 773, 18, 94, "Text"],
Cell[40177, 1038, 234, 6, 46, "Text"],
Cell[40414, 1046, 1167, 37, 143, "Input"],
Cell[41584, 1085, 221, 4, 46, "Text"],
Cell[41808, 1091, 118, 1, 32, "Input"],
Cell[41929, 1094, 111, 1, 32, "Input"],
Cell[42043, 1097, 117, 1, 32, "Input"],
Cell[42163, 1100, 189, 5, 46, "Text"],
Cell[42355, 1107, 891, 29, 43, "DisplayFormula"],
Cell[43249, 1138, 127, 3, 46, "Text"],
Cell[43379, 1143, 897, 29, 50, "Input"],
Cell[44279, 1174, 386, 10, 46, "Text"],
Cell[44668, 1186, 1462, 46, 47, "DisplayFormula"],
Cell[46133, 1234, 740, 21, 46, "DisplayFormula"],
Cell[46876, 1257, 282, 5, 46, "Text"],
Cell[47161, 1264, 907, 27, 53, "DisplayFormula"],
Cell[48071, 1293, 419, 10, 46, "Text"],
Cell[48493, 1305, 409, 8, 25, "DisplayFormula"],
Cell[48905, 1315, 391, 7, 25, "DisplayFormula"],
Cell[49299, 1324, 126, 4, 46, "Text"],
Cell[49428, 1330, 692, 21, 74, "Text"],
Cell[50123, 1353, 801, 27, 52, "Text"],
Cell[50927, 1382, 1578, 53, 220, "DisplayFormulaNumbered"],
Cell[52508, 1437, 296, 5, 46, "Text"],
Cell[52807, 1444, 640, 22, 77, "Input"],
Cell[53450, 1468, 189, 3, 46, "Text"],
Cell[53642, 1473, 611, 20, 53, "DisplayFormula"],
Cell[54256, 1495, 255, 4, 46, "Text"],
Cell[54514, 1501, 582, 20, 50, "DisplayFormula"],
Cell[55099, 1523, 306, 5, 46, "Text"],
Cell[55408, 1530, 1512, 47, 66, "DisplayFormulaNumbered"],
Cell[56923, 1579, 1553, 48, 66, "DisplayFormulaNumbered"],
Cell[58479, 1629, 321, 5, 46, "Text"],
Cell[58803, 1636, 887, 25, 27, "DisplayFormulaNumbered"],
Cell[59693, 1663, 807, 27, 74, "Text"],
Cell[60503, 1692, 2370, 73, 105, "Input"],
Cell[62876, 1767, 1162, 34, 102, "Text"],
Cell[64041, 1803, 1219, 40, 171, "Input"],
Cell[65263, 1845, 1276, 36, 35, "Input"],
Cell[66542, 1883, 1325, 37, 57, "Input"],
Cell[67870, 1922, 1229, 41, 171, "Input"],
Cell[69102, 1965, 1253, 35, 35, "Input"],
Cell[70358, 2002, 1251, 35, 35, "Input"],
Cell[71612, 2039, 586, 18, 46, "Text"],
Cell[72201, 2059, 972, 31, 143, "Input"],
Cell[73176, 2092, 221, 4, 46, "Text"],
Cell[73400, 2098, 317, 5, 32, "Input"],
Cell[73720, 2105, 314, 5, 32, "Input"],
Cell[74037, 2112, 319, 5, 32, "Input"],
Cell[74359, 2119, 74, 1, 46, "Text"],
Cell[74436, 2122, 376, 12, 35, "Input"],
Cell[74815, 2136, 162, 6, 46, "Text"],
Cell[74980, 2144, 162, 4, 32, "Input"],
Cell[75145, 2150, 188, 4, 32, "Input"],
Cell[75336, 2156, 148, 2, 46, "Text"],
Cell[75487, 2160, 565, 18, 56, "Input"],
Cell[76055, 2180, 532, 17, 56, "Input"],
Cell[76590, 2199, 154, 3, 46, "Text"],
Cell[76747, 2204, 2813, 89, 187, "DisplayFormula"],
Cell[79563, 2295, 888, 30, 46, "Text"],
Cell[80454, 2327, 2694, 86, 148, "Input"],
Cell[83151, 2415, 901, 25, 32, "Input"],
Cell[84055, 2442, 108, 2, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84200, 2449, 58, 0, 71, "Title"],
Cell[84261, 2451, 206, 5, 46, "Text"],
Cell[84470, 2458, 1228, 43, 97, "DisplayFormula"],
Cell[85701, 2503, 180, 4, 46, "Text"],
Cell[85884, 2509, 245, 5, 46, "Text"],
Cell[86132, 2516, 1292, 44, 66, "DisplayFormula"],
Cell[87427, 2562, 1327, 45, 66, "DisplayFormula"],
Cell[88757, 2609, 91, 1, 46, "Text"],
Cell[88851, 2612, 705, 23, 27, "DisplayFormula"],
Cell[89559, 2637, 179, 4, 46, "Text"],
Cell[89741, 2643, 212, 3, 46, "Text"],
Cell[89956, 2648, 2772, 86, 187, "DisplayFormula"],
Cell[92731, 2736, 117, 1, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92885, 2742, 461, 7, 71, "Title"],
Cell[93349, 2751, 489, 8, 94, "Text"],
Cell[93841, 2761, 71, 0, 46, "Text"],
Cell[93915, 2763, 453, 15, 143, "Input"],
Cell[94371, 2780, 165, 4, 32, "Input"],
Cell[94539, 2786, 50, 0, 46, "Text"],
Cell[94592, 2788, 640, 19, 143, "Input"],
Cell[95235, 2809, 376, 9, 55, "Input"],
Cell[95614, 2820, 49, 0, 46, "Text"],
Cell[95666, 2822, 766, 22, 187, "Input"],
Cell[96435, 2846, 37, 0, 46, "Text"],
Cell[96475, 2848, 601, 19, 165, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97113, 2872, 423, 8, 71, "Title"],
Cell[97539, 2882, 37, 0, 46, "Text"],
Cell[97579, 2884, 702, 19, 143, "Input"],
Cell[98284, 2905, 398, 8, 32, "Input"],
Cell[98685, 2915, 37, 0, 46, "Text"],
Cell[98725, 2917, 912, 24, 165, "Input"],
Cell[99640, 2943, 39, 0, 46, "Text"],
Cell[99682, 2945, 1028, 30, 187, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100747, 2980, 409, 7, 71, "Title"],
Cell[101159, 2989, 39, 0, 46, "Text"],
Cell[101201, 2991, 664, 20, 165, "Input"],
Cell[101868, 3013, 37, 0, 46, "Text"],
Cell[101908, 3015, 660, 19, 165, "Input"],
Cell[102571, 3036, 65, 0, 46, "Text"],
Cell[102639, 3038, 85, 1, 32, "Input"],
Cell[102727, 3041, 62, 1, 32, "Input"],
Cell[102792, 3044, 70, 0, 46, "Text"],
Cell[102865, 3046, 72, 1, 32, "Input"]
}, Open  ]]
}
]
*)

